# 星青创聚合登录 Python SDK

## 安装依赖

```bash
pip install requests
```

## 快速开始

```python
from oauth import OAuth

# 配置
oauth = OAuth(
    apiurl='https://login.xingqingchuang.com',
    appid='您的APPID',
    appkey='您的APPKEY',
    callback='https://您的网站/callback'
)

# 发起QQ登录
result = oauth.login('qq')
if result['code'] == 0:
    # 跳转到授权页面
    print('授权地址:', result['url'])
```

## 回调处理

```python
# 获取用户信息
code = request.args.get('code')  # Flask示例
result = oauth.callback(code)

if result['code'] == 0:
    social_uid = result['social_uid']  # 用户唯一标识
    nickname = result['nickname']       # 昵称
    faceimg = result['faceimg']         # 头像
    gender = result['gender']           # 性别
    
    # 处理您的登录逻辑...
```

## Flask 完整示例

```python
from flask import Flask, redirect, request
from oauth import OAuth

app = Flask(__name__)

oauth = OAuth(
    apiurl='https://login.xingqingchuang.com',
    appid='您的APPID',
    appkey='您的APPKEY',
    callback='https://您的网站/callback'
)

@app.route('/login/<type>')
def login(type):
    result = oauth.login(type)
    if result['code'] == 0:
        return redirect(result['url'])
    return f"登录失败: {result['msg']}"

@app.route('/callback')
def callback():
    code = request.args.get('code')
    result = oauth.callback(code)
    if result['code'] == 0:
        return f"登录成功! 欢迎 {result['nickname']}"
    return f"获取用户信息失败: {result['msg']}"

if __name__ == '__main__':
    app.run()
```

## 支持的登录类型

| type | 平台 |
|------|------|
| qq | QQ登录 |
| wx | 微信登录 |
| alipay | 支付宝登录 |
| sina | 微博登录 |
| github | GitHub登录 |
| ... | 更多平台 |
